/*
Programm par Maniack Crudelis.
http://www.crudelis.fr.tc
Pour des questions, remarques, suggestions et le support. Rendez-vous sur le forum du site.
*/

#ifndef NOMAJLOC_H
#define NOMAJLOC_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32    //win
#include <conio.h>
#else   //linux
#include "getch_taz.h"
#endif

#define MAXHISTO 10     //Dfinit la taille de l'historique de saisie

struct historique_saisie    //Structure des saisies entre
{
    int indexW;
    int indexR;
    char histo[MAXHISTO][255];
};

struct historique_saisie historique;

int chiffre_lettre(void);   /*Prend une saisie de chiffre mme sans maj-loc*/
char* nomajloc_des (char* chaine2);
char* nomajloc_attaque (char* chaine2);
char* nomajloc_calc (char* chaine2);
char* nomajloc_interpret_calc (char* chaine2);
char* nomajloc_gestion_combattant (char* chaine2);
char* nomajloc (char* chaine, int type);  /*Saisie de caractre avec gestion du majloc*/
void init_historique_saisie (void);     //Initialise la structure de l'historique
char* parcours_historique (int var_index);    //Parcours l'historique et envoi les chaines gardes en mmoire
void ajout_historique (char* chaine);       //Crer l'historique

int chiffre_lettre(void)
{
    char chaine[255];
    strcpy(chaine,nomajloc(chfunc,1));
    if(strstr(chaine,"q") != NULL || strstr(chaine,"Q") != NULL)
        return QUIT;  /*Envoie le signal quit*/
    if(chaine[0] == '\0')   /*Pas de saisie, appui sur entre direct*/
        return NA;
    return (atoi(chaine));
}

char* nomajloc_des (char* chaine2)
{
    char chaine[255];
    strcpy(chaine,nomajloc(chaine2,2));
    if(strstr(chaine,"q") != NULL || strstr(chaine,"Q") != NULL)
        exit(0);
    strcpy(chaine2,chaine);
    return (chaine2);
}

char* nomajloc_attaque (char* chaine2)
{
    char chaine[255];
    strcpy(chaine,nomajloc(chaine2,3));
    if(strstr(chaine,"q") != NULL || strstr(chaine,"Q") != NULL)
        exit(0);
    strcpy(chaine2,chaine);
    return (chaine2);
}

char* nomajloc_calc (char* chaine2)
{
    char chaine[255];
    strcpy(chaine,nomajloc(chaine2,4));
    if(strstr(chaine,"q") != NULL || strstr(chaine,"Q") != NULL)
        exit(0);
    strcpy(chaine2,chaine);
    return (chaine2);
}

char* nomajloc_interpret_calc (char* chaine2)
{
    char chaine[255];
    strcpy(chaine,nomajloc(chaine2,5));
    if(strstr(chaine,"q") != NULL || strstr(chaine,"Q") != NULL)
        exit(0);
    strcpy(chaine2,chaine);
    return (chaine2);
}

char* nomajloc_gestion_combattant (char* chaine2)
{
    char chaine[255];
    strcpy(chaine,nomajloc(chaine2,6));
    strcpy(chaine2,chaine);
    return (chaine2);
}


char* nomajloc (char* chaine, int type)
{
/*Type correspond  la fonction parente
1= chiffre_lettre
2= nomajloc_des
3= nomajloc_attaque
4= nomajloc_calc
5= nomajloc_interpret_calc
6= nomajloc_gestion_combattant*/
    int i,a,max=0;
    char saisie[255];
    char car;
    for(i=0;i<255;i++)
        saisie[i] = '\0';   //Initialise la chaine avec des fin de chaines.
    i=0;max=0;
    while((car=getch()) != 13)    /*Saisi caractre par caractre la saisie de l'utilisateur, puis le stocke directement dans la chaine.*/
    {
        a=0;
        #ifndef WIN32   //Linux
        if(car == -61)   //=-87; =-88; =-89; =-96;  -119;  -120;  -121;  -128
            car=getch();    //Saisi le 2e code ascii du caractre spcial
        else if(car == -62) //=-75; =-80; =-89
        {
            car=getch();    //Saisi le 2e code ascii du caractre spcial
            if(car == -89)  //Pour viter le conflit, on change -89 en -90
                car = -90;
        }
        #endif
        if(car < 48 || car > 57)    /*Si c'est pas un chiffre*/
        {
            switch (car)
            {
                case '&':
                    car = '1';
                    break;
                #ifdef WIN32    /*win*/
                case 130: //
                #else /*linux*/
                case -87: //
                case -119: //
                #endif
                    car = '2';
                    break;
                case '"':
                    car = '3';
                    break;
                case '\'':
                    car = '4';
                    break;
                case '(':
                    if(type != 4 && type != 5)   //calc et interpret calc ne transforme pas 5
                        car = '5';
                    else
                        car = '(';
                    break;
                case '-':
                    if(type != 3 && type != 4 && type != 5 && type != 6)   //calc, interpret calc, gestion_combattant et attaque ne transforme pas 6
                        car = '6';
                    else
                        car = '-';
                    break;
                #ifdef WIN32    /*win*/
                case 138: //
                #else /*linux*/
                case -88:
                case -120: //
                #endif //
                    car = '7';
                    break;
                case '_':
                    car = '8';
                    break;
                #ifdef WIN32    /*win*/
                case 135: //
                #else /*linux*/
                case -89: //
                case -121: //
                #endif
                    car = '9';
                    break;
                #ifdef WIN32    /*win*/
                case 133: //
                #else /*linux*/
                case -96:
                case -128: //
                #endif //
                    car = '0';
                    break;
                case 'd':
                case 'D':
                    if(type == 2)   //Seul des tranforme d
                        car = 'd';
                    else
                        a=1;
                    break;
                case ' ':
                    if(type == 2)   //Seul des tranforme espace
                        car = ' ';
                    else
                        a=1;
                    break;
                case '+':
                case '=':
                    if(type == 3 || type == 4 || type == 5 || type == 6)   //Seul attaque, calc, gestion_combattant et interpret calc transforment +
                        car = '+';
                    else
                        a=1;
                    break;
                case '/':
                case '\\':
                case ':':
                    if(type == 3 || type == 4 || type == 5)   //Seul attaque, calc et interpret calc transforment /
                        car = '/';
                    else
                        a=1;
                    break;
                case ',': /*virgule pour chiffre float*/
                case '?':
                case '.':
                case ';':
                    if(type == 4 || type == 5)   //Seul calc et interpret calc transforment .
                        car = '.';
                    else
                        a=1;
                    break;
                case '*':
                #ifdef WIN32    /*win*/
                case 230:   //230=
                #else /*linux*/
                case -75: //
                #endif
                    if(type == 4 || type == 5)   //Seul calc et interpret calc transforment *
                        car = '*';
                    else
                        a=1;
                    break;
                case ')':
                #ifdef WIN32    /*win*/
                case 248:   //248=
                #else /*linux*/
                case -80: //
                #endif
                    if(type == 4 || type == 5)   //Seul calc et interpret calc transforment )
                        car = ')';
                    else
                        a=1;
                    break;
                case '!':
                #ifdef WIN32    /*win*/
                case 245:   //245=
                #else /*linux*/
                case -90: //
                #endif
                    if(type == 4)   //Seul calc transforme !
                        car = '!';
                    else
                        a=1;
                    break;
                case 'e':
                case 'E':
                    if(type == 4)   //Seul calc transforme E
                        car = 'E';
                    else
                        a=1;
                    break;
                case 'f':
                case 'F':
                    if(type == 4)   //Seul calc transforme F
                        car = 'F';
                    else
                        a=1;
                    break;
                case 'm':
                case 'M':
                case 'n':
                case 'N':
                case 'p':
                case 'P':
                case 'r':
                case 'R':
                case 's':
                case 'S':
                    if(type != 6)   //Seul gestion_combattant transforme M, N, P, R et S
                        a=1;
                    break;
                case 'q':
                case 'Q':
                    //car reste  la valeur q ou Q.
                    break;
                #ifdef WIN32    /*win*/
                case -32:   //Caractres spciaux
                #else /*linux*/
                case 27:   //Caractres spciaux
                #endif
                    car=getch();  /*Prend le deuxime code ascii du caractre spcial*/
                    #ifndef WIN32   //linux
                    if(car == 91)
                    {
                        car=getch();    //Saisi le 3e code ascii du caractre spcial
                        if(car == 53 || car == 54)  //Pour pageup et pagedown
                            getch();    //Saisie le 4e code ascii, correspondant  126
                    }
                    #endif
                    #ifdef WIN32    /*win*/
                    if (car == 73 || car == 72 || car == 80 || car == 81)
                    #else /*linux*/
                    if (car == 65 || car == 66 || car == 53 || car == 54)
                    #endif
                    {   //haut, bas, pageup ou pagedown = utilisation de l'historique
                        for(a=0;a<i;a++)
                            printf("\b");   //Recule jusqu'au dbut de la chaine
                        for(a=0;a<i;a++)
                            printf(" ");   //Et efface tout
                        for(a=0;a<i;a++)
                            printf("\b");   //Puis reviens au dbut
                        #ifdef WIN32    /*win*/
                        if(car == 73)   //Pageup
                        #else /*linux*/
                        if(car == 53)   //Pageup
                        #endif
                            strcpy(saisie,parcours_historique(-MAXHISTO+1));
                        #ifdef WIN32    /*win*/
                        if(car == 72)   //Haut
                        #else /*linux*/
                        if(car == 65)   //Haut
                        #endif
                            strcpy(saisie,parcours_historique(-1));
                        #ifdef WIN32    /*win*/
                        if(car == 80)   //Bas
                        #else /*linux*/
                        if(car == 66)   //Bas
                        #endif
                            strcpy(saisie,parcours_historique(1));
                        #ifdef WIN32    /*win*/
                        if(car == 81)   //Pagedown
                        #else /*linux*/
                        if(car == 54)   //Pagedown
                        #endif
                            strcpy(saisie,parcours_historique(MAXHISTO-1));
                        max = strlen(saisie);
                        i=max;
                        printf("%s",saisie);
                    }
                    #ifdef WIN32    /*win*/
                    if(car == 71 && i>0)
                    #else /*linux*/
                    if(car == 72 && i>0)
                    #endif
                    {   //Origine
                        for(;i>0;i--)
                            printf("\b");   //Recule le curseur jusqu'au dbut. i passe  0
                    }
                    #ifdef WIN32    /*win*/
                    if(car == 75 && i>0)
                    #else /*linux*/
                    if(car == 68 && i>0)
                    #endif
                    {   //Gauche
                        i--;    //Recule d'une case dans le tableau
                        printf("\b");   /*Retour du curseur sur la case d'avant*/
                    }
                    #ifdef WIN32    /*win*/
                    if(car == 77 && i != max)
                    #else /*linux*/
                    if(car == 67 && i != max)
                    #endif
                    {   //Droite
                        printf("%c",saisie[i]);     //Rcrit le caractre pour avancer
                        i++;    //Avance  d'une case dans le tableau
                    }
                    #ifdef WIN32    /*win*/
                    if(car == 79 && i != max)
                    #else /*linux*/
                    if(car == 70 && i != max)
                    #endif
                    {   //Fin
                        do
                        {
                            printf("%c",saisie[i++]);     //Rcrit le caractre pour avancer
                        }while(i != max);    //Jusqu' la fin de la chaine
                    }
                    #ifdef WIN32    /*win*/
                    if(car == 83)
                    #else /*linux*/
                    if(car == 51)
                    #endif
                    {   //Suppr, procdure similaire  celle suivante, retour clavier
                        if(i<max)   /*Si pas en fin de chaine*/
                        {
                            for(a=i;a<max;a++)    //rutilise a en variable de boucle
                                saisie[a] = saisie[a+1];    //Dcale la chaine pour supprimer le caractre
                            for(a=i;a<max;a++)
                                printf("%c", saisie[a]);    //Dcale l'affichage
                            #ifndef WIN32 /*linux*/
                            printf(" ");    //Efface le dernier caractre de l'affichage
                            #endif
                            for(;a>i;a--)
                                printf("\b");   //Remet le curseur  sa place
                            saisie[max] = '\0'; //Annule le dernier caractre de la chaine
                            max--; /*Annule le caractre qui a t effac*/
                        }
                    }
                    a=1;
                    break;
                #ifdef WIN32    /*win*/
                case 8:     //Commande retour clavier
                #else /*linux*/
                case 127:     //Commande retour clavier
                #endif
                    if(i>0)   /*Si pas en dbut de chaine*/
                    {
                        printf("\b");   /*Retour du curseur sur la case d'avant*/
                        if(i<max)
                        {   //Si on efface un caractre en milieu de chaine, dcalage
                            for(a=i-1;a<max;a++)    //rutilise a en variable de boucle
                                saisie[a] = saisie[a+1];    //Dcale la chaine pour supprimer le caractre
                            for(a=i-1;a<max;a++)
                                printf("%c", saisie[a]);    //Dcale l'affichage
                            for(;a>i-1;a--)
                                printf("\b");   //Remet le curseur  sa place
                        }
                        else
                        {   //Si fin de chaine, suppression simple
                            printf(" ");
                            printf("\b");
                            saisie[i-1] = '\0'; /*Efface le caractre dans le tableau*/
                        }
                        saisie[max] = '\0'; //Annule le dernier caractre de la chaine
                        i--;max--; /*Annule le caractre qui a t effac*/
                    }
                    a=1;
                    break;
                default:
                    a=1;
            }
        }
        //Si c'est un chiffre, aucune modification du caractre. a reste  0 pour l'affichage
        if(!a)  //Si caractre affich, i se dplace
        {
            if(i<max)
            {   //Si on affiche un caractre en milieu de chaine, insertion
                for(a=max+1;a>i;a--)    //rutilise a en variable de boucle
                    saisie[a] = saisie[a-1];    //Dcale la chaine pour insrer le nouveau car
                for(a=i;a<max+1;a++)
                    printf("%c", saisie[a]);    //Dcale l'affichage
                for(;a>i;a--)
                    printf("\b");   //Remet le curseur  sa place
            }
            printf("%c", car);  //Affiche  l'cran le caractre corrig
            saisie[i] = car;    //Copie le caractre dans la chaine
            i++;
            max++;  //Et max augmente de 1
        }
    }
    puts("");
//! 13 ou 10 pour un appui sur entre???
    if(saisie[0] == 13 || saisie[0] == 10)   //Pas de saisie, appui sur entre direct
        saisie[0]='\0'; /*Cr une chaine vide*/
    else
        ajout_historique(saisie);   //Ajoute la chaine qui vient d'tre saisie  l'historique (si c'est pas une chaine vide)
    strcpy(chaine,saisie);
    return (chaine);
}

void init_historique_saisie (void)
{
    int i;
    historique.indexR = 0;   //Place l'index de lecture au dbut du tableau
    historique.indexW = 0;   //Place l'index d'criture au dbut du tableau
    for(i=0;i<MAXHISTO;i++)
        historique.histo[i][0] = '\0';  //Initialise les chaines  null
}

void ajout_historique (char* chaine)
{
    strcpy(historique.histo[historique.indexW],chaine);
    historique.indexW++;
    if(historique.indexW == MAXHISTO)   //Retourne au dbut du tableau si l'index arrive  la fin
        historique.indexW = 0;
    historique.indexR = historique.indexW;
}

char* parcours_historique (int var_index)
{
    int i=1;
    historique.indexR += var_index;
    if(historique.indexR < 0)
        historique.indexR = 0;
    if(historique.indexR > MAXHISTO-1)
        historique.indexR = MAXHISTO-1;
    if(var_index == MAXHISTO-1) //Si appui sur la touche pagedown
        var_index = -1;     //Aprs tre aller en fin de tableau, var_index prend -1 pour remonter jusqu' la dernire saisie du tableau
    while(historique.histo[historique.indexR][0] == '\0')
    {   //Tant que la chaine est vide, cherche la suivante.
        i++;
        historique.indexR += var_index;    //Passe  la chaine suivante, dans le sens donn par var_index
        if(historique.indexR < 0)
            historique.indexR = 0;
        if(historique.indexR > MAXHISTO-1)
        {
            historique.indexR = MAXHISTO-1;
            var_index = -1;     //Si l'historique arrive au max, var_index s'inverse pour avoir la dernire valeur de l'historique
        }
        if(i==MAXHISTO*2)   //La boucle  tourne MAXHISTO*2 fois sans trouver de chaine non vide, donc pas de chaine non vide
            break;  //Arrt de la boucle
    }
    return historique.histo[historique.indexR];
}

#endif
